CKEDITOR.dialog.add( 'shopWidget', function( editor ) {
    var shopWidgets = {
        title: 'shopWidget',
        minWidth: 500,
        minHeight: 300,

        contents: [
            {
                id: 'product_list',
                label: 'Produktauflistung',
                elements: [
                    {
                        id: 'module',
                        label: 'Welche Produkte sollen angezeigt werden: ',
                        type: 'select',
                        items: [
                            [ 'Produkte aus einer Kategorie', 'category' ],
                            [ 'Startseiten Produkte', 'startpage' ],
                            [ 'Neueste Produkte','newest' ],
                            [ 'Bestseller Produkte', 'bestseller' ],
                            [ 'Sonderpreis Produkte', 'special' ],
                            [ 'Upcoming Produkte', 'upcoming' ]
                        ],


                        setup: function (widget) {
                            this.setValue(widget.data.module);
                        },
                        commit: function (widget) {
                            widget.setData('module', this.getValue());
                        }
                    },
                    {
                        id: 'category',
                        label: 'Aus welcher Kategorie sollen die Produkte angezeigt werden: ',
                        type: 'select',
                        items: [],

                        onLoad: function() {
                            var items = getData('getCategories');

                            for (var i = 0; i < items.length; i++) {
                                this.add(items[i][0], items[i][1], i+1);
                            }
                        },

                        setup: function (widget) {
                            this.setValue(widget.data.category);
                        },
                        commit: function (widget) {
                            widget.setData('category', this.getValue());
                        }
                    }
                ]
            },
            {
                id: 'category_list',
                label: 'Kategorieauflistung',
                elements: [
                    {
                        id: 'module',
                        label: 'Welche Produkte sollen angezeigt werden: ',
                        type: 'select',
                        'default': 'Top Kategorien',
                        items: [
                            [ 'Top Kategorien', 'top_category' ],
                            [ 'Manuelle Auswahl', 'manual' ]
                        ],

                        onShow: function() {
                            toggleSelectCategories(this);
                        },
                        onChange: function() {
                            toggleSelectCategories(this);
                        },

                        setup: function (widget) {
                            this.setValue(widget.data.module);
                        },
                        commit: function (widget) {
                            widget.setData('module', this.getValue());
                        }
                    },
                    {
                        id: 'categories',
                        label: 'Welche Kategorien sollen angezeigt werden: ',
                        type: 'select',
                        multiple: true,
                        size: 10,
                        inputStyle: 'height: auto',
                        items: [],

                        onLoad: function() {
                            var items = getData('getCategories');

                            // start with 1 to ignore the "Keine Auswahl" item
                            for (var i = 1; i < items.length; i++) {
                                this.add(items[i][0], items[i][1], i+1);
                            }
                        },

                        // use jQuery because ckeditor api do not support multiple values
                        setup: function (widget) {
                            var values = widget.data.categories;
                            values = values && values.length > 0 ? values.split(',') : '';

                            $(this.getInputElement().$).val(values);
                        },
                        commit: function (widget) {
                            var $select = $(this.getInputElement().$),
                                values = '';

                            if ($select.length > 0 && !$select.is(':disabled')) {
                                values = $select.val().join(',');
                            }

                            widget.setData('categories', values);
                        }
                    },
                    {
                        id: 'sub_categories',
                        label: 'Unterkategorien miteinbeziehen',
                        type: 'checkbox',

                        setup: function (widget) {
                            var value = widget.data.sub_categories;
                            if (typeof value === 'string') {
                                value = value == 'true';
                            }

                            this.setValue(value);
                        },
                        commit: function (widget) {
                            var value = this.getValue();
                            if (typeof value === 'string') {
                                value = value == 'true';
                            }

                            widget.setData('sub_categories', value);
                        }
                    }
                ]
            },
            {
                id: 'youtube_video',
                label: 'Youtube-Video',
                elements: [
                    {
                        id: 'video_url',
                        label: 'Video-URL:',
                        type: 'text',

                        setup: function (widget) {
                            this.setValue(widget.data.video_url);
                        },
                        commit: function (widget) {
                            widget.setData('video_url', this.getValue());
                        }
                    },
                ]
            },
            {
                id: 'special_product',
                label: 'Spezialprodukt',
                elements: [
                    {
                        id: 'product',
                        label: 'Produkt',
                        type: 'select',
                        items: getData('../../../../../../index.php?page=xtlive_elements&page_action=getProducts'),

                        setup: function(widget){
                            this.setValue(widget.data.product);
                        },

                        commit: function(widget){
                            widget.setData('product', this.getValue());
                        }
                    }
                ]
            },
            {
                id: 'jumbo_box',
                label: 'Jumbo Box',
                elements: [
                    {
                        id: 'size',
                        label: 'Größe:',
                        type: 'select',
                        items: [
                            [ 'Klein', 'small-h' ],
                            [ 'Mittel', 'middle-h' ],
                            [ 'Groß', 'big-h' ],
                        ],

                        setup: function (widget) {
                            this.setValue(widget.data.size);
                        },
                        commit: function (widget) {
                            widget.setData('size', this.getValue());
                        }
                    },
                    {
                        id: 'horizontal',
                        label: 'Horizontal:',
                        type: 'select',
                        items: [
                            [ 'Links', 'left' ],
                            [ 'Mitte', 'center' ],
                            [ 'Rechts', 'right' ],
                        ],

                        setup: function (widget) {
                            this.setValue(widget.data.horizontal);
                        },
                        commit: function (widget) {
                            widget.setData('horizontal', this.getValue());
                        }
                    },

                    {
                        id: 'vertical',
                        label: 'Vertikal:',
                        type: 'select',
                        items: [
                            [ 'Oben', 'top' ],
                            [ 'Mitte', 'middle' ],
                            [ 'Unten', 'bottom' ],
                        ],

                        setup: function (widget) {
                            this.setValue(widget.data.vertical);
                        },
                        commit: function (widget) {
                            widget.setData('vertical', this.getValue());
                        }
                    },
                    {
                        id: 'header',
                        label: 'Überschrift:',
                        type: 'text',

                        setup: function (widget) {
                            this.setValue(widget.data.header);
                        },
                        commit: function (widget) {
                            widget.setData('header', this.getValue());
                        }
                    },
                    {
                        id: 'text',
                        label: 'Text:',
                        type: 'textarea',

                        setup: function (widget) {
                            this.setValue(widget.data.text);
                        },
                        commit: function (widget) {
                            widget.setData('text', this.getValue());
                        }
                    },
                    {
                        id: 'link',
                        label: 'Link:',
                        type: 'text',

                        setup: function (widget) {
                            this.setValue(widget.data.link);
                        },
                        commit: function (widget) {
                            widget.setData('link', this.getValue());
                        }
                    },
                    {
                        id: 'btnName',
                        label: 'Button Name:',
                        type: 'text',

                        setup: function (widget) {
                            this.setValue(widget.data.btnName);
                        },
                        commit: function (widget) {
                            widget.setData('btnName', this.getValue());
                        }
                    }
                ]
            },



        ]
    };
    $.publish("plugin/xtliveElements/shopWidgetDialogDefinition", [shopWidgets]);
    return shopWidgets;
} );

function toggleSelectCategories(element) {
    var dialog = element.getDialog(),
        selectCategories = dialog.getContentElement('category_list','categories'),
        fn = element.getValue() === 'top_category' ? 'disable' : 'enable';

    selectCategories[fn]();
}

function getData(_function){
    var array = [], url;
    url = '//' + location.hostname;
    url += location.pathname.replace(/xtAdmin\/ejsadmin\.php/, '');
    url += 'index.php?page=xtlive_elements&page_action=' + _function;

    $.ajax({
        type: 'GET',
        url: url,
        contentType: 'application/json',
        dataType: 'JSON',
        async: false,
        success: function(response){
            $.each(eval(response), function(k,v){
                array.push(v);
            });
        },
        error: function(response){
            console.log('error');
        }
    });

    return array;
}