

CKEDITOR.plugins.add( 'shopWidget', {
    requires: 'widget',
    icons: 'shopWidget',

    init: function( editor ) {
        CKEDITOR.dialog.add( 'shopWidget', this.path + 'dialogs/shopWidget.js' );

        editor.widgets.add( 'shopWidget', {
            dialog: 'shopWidget',

            upcast: function( element ) {
                return element.hasClass( 'widget' ) && !element.hasClass( 'fake-widget' );
            },

            /**
             * set parameters for shopWidget dialog based on data-smarty attribute in template
             */
            init: function(){
                //var pattern = /([A-Za-z_]+)=([A-Za-z0-9_]+)/g;
                var pattern = /([A-Za-z_]+)=('((.|\s)*?')|[^\s\}]+)/g; // allow simple properties (propertyKey=propertyValue) and also string as property value (propertyKey='This is an example for a property value')
                var data_smarty = $(this.element.$).attr('data-smarty');
                var key, value;

                // parsing data-smarty and set values e.g. box_type='product_list'
                while((m = pattern.exec(data_smarty)) !== null) {
                    key = m[1];
                    value = m[2].replace(/'/g, '');

                    this.setData(key, value);
                }
            },

            data: function() {
                $.publish("plugin/xtliveElements/dataFunctionTop",[this]);
                if (typeof this.data.box_type  != 'undefined'){
                    var html = '',  box = '', name = '', tpl = '', viewtype = '', type = '';

                    // check variable value
                    if (typeof this.data.name === 'undefined') this.data.name = 'xtlive_elements';
                    if (typeof this.data.type === 'undefined') this.data.type = 'user';
                    if (typeof this.data.tpl === 'undefined') this.data.tpl = '';
                    if (typeof this.data.viewtype === 'undefined') this.data.viewtype = '';

                    if(this.data.tpl !== '') tpl = " tpl='" + this.data.tpl + "'";
                    if(this.data.viewtype !== '') viewtype = " viewtype='" + this.data.viewtype + "'";

                    box_type = " box_type='" + this.data.box_type + "'";
                    name = " name='" + this.data.name + "'";
                    type = " type='" + this.data.type + "'";

                    switch(this.data.box_type){
                        case 'product_list':
                            var module = '', category = '';

                            // check variable value
                            if (typeof this.data.module === 'undefined') this.data.module = '';
                            if (typeof this.data.category === 'undefined') this.data.category = '';
                            if (this.data.module !== '') module = " module='" + this.data.module + "'";
                            if (this.data.category !== '') category = " category='" + this.data.category + "'";

                            // backend template output
                            $(this.element.$).find(':header').text('Produktauflistung');
                            html += '<strong>Modul: </strong>' + this.data.module + '<br />';
                            html += '<strong>Kategorie: </strong>' + this.data.category + '<br />';
                            $(this.element.$).find('p').html(html);

                            // setting data-smarty attribute
                            box = '{box' + name + box_type +  module + category + tpl + viewtype + type + '}';
                            $(this.element.$).attr('data-smarty', box);
                            break;

                        case 'category_list':
                            var module = '', categories = '', sub_categories = '';

                            // check variable value
                            if (typeof this.data.module === 'undefined') this.data.module = '';
                            if (typeof this.data.categories === 'undefined') this.data.categories = '';
                            if (typeof this.data.sub_categories === 'undefined') this.data.sub_categories = '';
                            if (this.data.module !== '') module = " module='" + this.data.module + "'";
                            if (this.data.categories !== '') categories = " categories='" + this.data.categories + "'";
                            if (this.data.sub_categories !== '') sub_categories = " sub_categories=" + this.data.sub_categories + "";

                            // backend template output
                            $(this.element.$).find(':header').text('Kategorieauflistung');
                            html += '<strong>Modul: </strong>' + this.data.module + '<br />';

                            if (this.data.categories !== '') {
                                html += '<strong>Kategorien: </strong>' + this.data.categories + '<br />';
                            }

                            html += '<strong>Unterkategorien: </strong>' + this.data.sub_categories + '<br />';
                            $(this.element.$).find('p').html(html);

                            // setting data-smarty attribute
                            box = '{box' + name + box_type +  module + categories + sub_categories + tpl + viewtype + type + '}';
                            $(this.element.$).attr('data-smarty', box);
                            break;

                        case 'youtube_video':
                            var video_url = '';
                            // check variable value
                            if (typeof this.data.video_url === 'undefined') this.data.video_url = '';
                            if (this.data.video_url !== '') video_url = " video_url='" + this.data.video_url + "'";

                            // backend template output
                            $(this.element.$).find(':header').text('Youtube-Video');
                            html += '<strong>Video: </strong>' + this.data.video_url + '<br />';
                            $(this.element.$).find('p').html(html);

                            // setting data-smarty attribute
                            box = '{box' + name + box_type +  video_url + tpl + type + '}'
                            $(this.element.$).attr('data-smarty', box);
                            break;

                        case 'jumbo_box':
                            var size = '', vertical = '', horizontal = '', header = '', text = '', link = '', btnName;

                            // check variable value
                            if (typeof this.data.size === 'undefined') this.data.size = '';
                            if (typeof this.data.vertical === 'undefined') this.data.vertical = '';
                            if (typeof this.data.horizontal === 'undefined') this.data.horizontal = '';
                            if (typeof this.data.header === 'undefined') this.data.header = '';
                            if (typeof this.data.text === 'undefined') this.data.text = '';
                            if (typeof this.data.link === 'undefined') this.data.link = '';
                            if (typeof this.data.btnName === 'undefined') this.data.btnName = '';

                            if (this.data.size !== '') size = " size='" + this.data.size + "'";
                            if (this.data.vertical !== '') vertical = " vertical='" + this.data.vertical + "'";
                            if (this.data.horizontal !== '') horizontal = " horizontal='" + this.data.horizontal + "'";
                            if (this.data.header !== '') header = " header='" + this.data.header + "'";
                            if (this.data.text !== '') text = " text='" + this.data.text + "'";
                            if (this.data.link !== '') link = " link='" + this.data.link + "'";
                            if (this.data.btnName !== '') btnName = " btnName='" + this.data.btnName + "'";

                            // backend template output
                            $(this.element.$).find(':header').text('Jumbo Box');
                            html += '<strong>Größe: </strong>' + this.data.size + '<br />';
                            html += '<strong>Horizontal: </strong>' + this.data.horizontal + '<br />';
                            html += '<strong>Vertikal: </strong>' + this.data.vertical + '<br />';
                            html += '<strong>Überschrift: </strong>' + this.data.header + '<br />';
                            html += '<strong>Text: </strong>' + this.data.text + '<br />';
                            html += '<strong>Link: </strong>' + this.data.link + '<br />';
                            html += '<strong>Button Name: </strong>' + this.data.btnName + '<br />';
                            $(this.element.$).find('p').html(html);

                            // setting data-smarty attribute
                            box = '{box' + name + box_type + size + horizontal + vertical + header + text + link + btnName + tpl + type + '}'
                            $(this.element.$).attr('data-smarty', box);
                            break;
                        default:
                            $.publish("plugin/xtliveElements/dataBoxTypeDefault",[this]);
                            break;
                    }
                }
                $.publish("plugin/xtliveElements/dataFunctionBottom",[this]);
            },
        draggable: false
        });

        // disable backspace and delete button
        editor.widgets.on('instanceCreated', function(evt){
            var widget = evt.data;
            widget.on('key', function(event){
                if(event.data.keyCode == 8 || event.data.keyCode == 46){
                    event.cancel();
                }
            });
        });
    }
});



CKEDITOR.on( 'dialogDefinition', function( ev ) {
    var dialogName = ev.data.name,
        dialogDefinition = ev.data.definition;

    if ( dialogName == 'shopWidget' ) {
        var currentTab = ev.editor.widgets.focused.data.box_type,
            tabs = dialogDefinition.contents,
            tabsToRemove = [];

        $.each(tabs, function(){
            if(currentTab === this.id){
                dialogDefinition.title = this.label;
            }else{
                tabsToRemove.push(this.id);
            }
        });

        $.each(tabsToRemove, function(){
            dialogDefinition.removeContents(this);
        });
    }
});